#version 140
#extension GL_EXT_gpu_shader4 : enable
// StrangeFoamMod01.fsh  by   olli666
//https://www.shadertoy.com/view/tlKSWw
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// strange foam of coloured bubbles. wonderfully wasteful calculation.
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{   
    float timeScale = iTime * 0.1;
    
    gl_FragColor = vec4(0.2,0.4,0.8,0.0);
    // draw N bubbles. use fragColor.a channel to plot only the highest bubble.
    for (float i = 0.0 ; i < 50.0; i ++) {
        // bubble's coordinate
        vec2 ax = vec2(0.9+0.7*cos(timeScale+i*23.0), 0.7+0.6*sin(timeScale+i*17.0));       
        
        // current pixel "height" vs. the given bubble
	    vec2 uv = gl_FragCoord.xy/iResolution.y - ax;
        float sizeScale = 5.0 + 5.0*(1.0+cos(5.0*(timeScale + i)));
        float height = 1.0 - sizeScale*(uv.x*uv.x + uv.y*uv.y);
        
        if (height > gl_FragColor.a) {
            // highest bubble so far, colorize & apply
			gl_FragColor = height*vec4(                
                0.6+0.4*cos(i+timeScale), 
                0.6+0.4*sin(i+timeScale), 
                0.8+0.4*(sin(3.0*i)+cos(2.0*i)),
                1.0
            );
        }
    }
    gl_FragColor.a = 1.0;
}